
SRC = $(wildcard $(NHDIR)source/*.cpp)
OBJ = $(patsubst $(NHDIR)source/%.cpp, %.o, $(SRC))
DEP = $(patsubst $(NHDIR)source/%.cpp, %.d, $(SRC))


SO = libgordon1966_$(PLAT).$(SFX)
LIB = $(NHDIR)build/lib/$(SO)

FECORE = $(FEBLIB)/libfecore_$(PLAT).$(SLIB)

FEBIOMECH = $(FEBLIB)/libfebiomech_$(PLAT).$(SLIB)

FEBIOLIBS = $(FEBIOMECH) $(FECORE)

$(LIB): $(OBJ)
ifeq ($(findstring lnx,$(PLAT)),lnx)
		$(CC) $(FLG) -shared -Wl,-soname,$(SO) -o $(LIB) $(OBJ) $(FEBIOLIBS)
else ifeq ($(findstring gcc,$(PLAT)),gcc)
		$(CC) $(FLG) -shared -Wl,-soname,$(SO) -o $(LIB) $(OBJ) $(FEBIOLIBS)
else ifeq ($(findstring osx,$(PLAT)),osx)
		$(CC) $(FLG) -dynamiclib -o $(LIB) $(OBJ) $(FEBIOLIBS)
else ifeq ($(findstring win,$(PLAT)),win)		
		$(CC) $(FLG) -dynamiclib -o $(LIB) $(OBJ) $(FEBIOLIBS)
endif

%.o: $(NHDIR)source/%.cpp
	$(CC) $(INC) $(DEF) $(FLG) -MMD -c -o $@ $<

clean:
	$(RM) *.o *.d $(LIB)

-include $(DEP)
